<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

use BaconQrCode\Renderer\ImageRenderer;
use BaconQrCode\Renderer\Image\SvgImageBackEnd;
use BaconQrCode\Renderer\RendererStyle\RendererStyle;
use BaconQrCode\Writer;

class Settings extends Home_Controller {

    public function __construct()
    {
        parent::__construct();
    }

    
    public function index()
    {
        $this->add_settings_lang();

        if (!is_admin()) {
            redirect(base_url());
        }

        $data = array();
        $data['page_title'] = 'System Settings';
        $data['page'] = 'Settings';
        $data['settings'] = $this->admin_model->get('settings');
        $data['currencies'] = $this->admin_model->select_asc('country');
        $data['time_zones'] = $this->admin_model->select_asc('time_zone');
        $data['settings_language'] = $this->admin_model->select_asc('settings_extra');
        $data['main_content'] = $this->load->view('admin/settings', $data, TRUE);
        $this->load->view('admin/index', $data);
    }


    public function add_settings_lang()
    {
        $languages = $this->admin_model->select('language');

        foreach ($languages as $language) {
            $settings_lang =  $this->admin_model->get_by_langid($language->id);
            if ($settings_lang == 0) {
                $data=array(
                    'lang_id' => $language->id
                );
                $this->admin_model->insert($data, 'settings_extra');
            }
        }
    }



    public function company()
    {
        if (!is_user()) {
            redirect(base_url());
        }
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'System Settings';
        $data['company'] = $this->admin_model->get_company(user()->id);
        $data['categories'] = $this->admin_model->select_order_by_name('categories');
        $data['currencies'] = $this->admin_model->select_asc('country');
        $data['main_content'] = $this->load->view('admin/user/settings', $data, TRUE);
        $this->load->view('admin/index', $data);
    }


    public function general()
    {

        if (!is_user()) {
            redirect(base_url());
        }
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'General Settings';
        $data['languages'] = $this->admin_model->get_language();
        $data['company'] = $this->admin_model->get_company(user()->id);
        $data['currencies'] = $this->admin_model->select_asc('country');
        $data['time_zones'] = $this->admin_model->select_asc('time_zone');
        $data['main_content'] = $this->load->view('admin/user/general_settings', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    
    function searchForId($value, $array) {
       foreach ($array as $key => $val) {
           if ($val == $value) {
               return $key;
           }
       }
       return 'null';
    }


    public function holidays()
    {
        if (isset($_GET['msg']) && $_GET['msg'] == 'success') {
            $this->session->set_flashdata('msg', trans('updated-successfully')); 
        }

        if (!is_user()) {
            redirect(base_url());
        }
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'Holidays';
        $data['company'] = $this->admin_model->get_company(user()->id);
        $data['main_content'] = $this->load->view('admin/user/holidays', $data, TRUE);
        $this->load->view('admin/index', $data);
    }


    
    public function add_holidays($date){

        $holidays = json_decode($this->business->holidays, true);
      
        if (!empty($holidays)) {
            
            if (($key = array_search($date, $holidays)) !== false) {
                unset($holidays[$key]);
                $holidays = array_values($holidays);
            }else{
                array_push($holidays, $date);
            }
        } else {
            $holidays = array($date);
        }
        //echo "<pre>"; print_r($holidays); exit();

        $data = array(
            'holidays' => json_encode($holidays)
        );
        $this->admin_model->edit_option($data, $this->business->id, 'business');

        $data['status'] = 1;
        die(json_encode($data));
    }
    


    public function sms()
    {
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'SMS Settings';
        $data['main_content'] = $this->load->view('admin/user/sms_settings', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    public function whatsapp()
    {
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'Whatsapp Settings';
        $data['main_content'] = $this->load->view('admin/user/whatsapp_settings', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    public function meeting()
    {
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'Meeting Settings';
        $data['main_content'] = $this->load->view('admin/user/metting_settings', $data, TRUE);
        $this->load->view('admin/index', $data);
    }


    public function embedded_code()
    {
        if (!is_user()) {
            redirect(base_url());
        }

        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'Embedded Settings';
        $data['company'] = $this->admin_model->get_company(user()->id);
        $data['main_content'] = $this->load->view('admin/user/embd_code', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    public function qr_code()
    {
        if (!is_user()) {
            redirect(base_url());
        }

        if ($this->business->qr_code == '') {
            $this->generate_qucode($this->business->slug);
        }

        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'QR Settings';
        $data['company'] = $this->admin_model->get_company(user()->id);
        $data['main_content'] = $this->load->view('admin/user/generate_code', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    public function generate_qucode($slug)
    {
        if (check_feature_access('custom-domain') == TRUE):
          if (!empty(get_user_domain($this->session->userdata('id')))):
            $user_domain = get_user_domain($this->session->userdata('id'))->custom_domain;
          else:
            $user_domain = base_url($this->business->slug);
          endif;
        else:
          $user_domain = base_url($this->business->slug);
        endif;





        //$qrData = $user_domain; 
        $qrData = $user_domain; 
        $filename = 'qr_' . time() . '.svg';
        $savePath = FCPATH . 'uploads/files/' . $filename;
        $renderer = new ImageRenderer(
            new RendererStyle(300), // 300px size
            new SvgImageBackEnd()
        );

        $writer = new Writer($renderer);

        // Generate and save the image
        $qr_file = $writer->writeFile($qrData, $savePath);
        
        $data = array(
            'qr_code' => 'uploads/files/'.$filename
        );
        $this->admin_model->edit_option($data, $this->business->id, 'business');
        


    }

    public function download_qrcode()
    {
        $this->load->helper('download');
        $file_name = basename($this->business->qr_code);
        $data = file_get_contents($this->business->qr_code);
        $name = $file_name;

        force_download($name, $data); 
        $this->session->set_flashdata('msg', $file.' '.trans('downloaded-successfully'));
    }


    public function profile()
    {
        if (!is_user()) {
            redirect(base_url());
        }
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'Profile';
        $data['main_content'] = $this->load->view('admin/user/profile', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    public function update_company(){

        check_status();

        $id = $this->input->post('id');

        if(!empty($this->input->post('enable_gallery'))){$enable_gallery = $this->input->post('enable_gallery', true);}
        else{$enable_gallery = 0;}

        if(!empty($this->input->post('enable_staff'))){$enable_staff = $this->input->post('enable_staff', true);}
        else{$enable_staff = 0;}

        if(!empty($this->input->post('enable_rating'))){$enable_rating = $this->input->post('enable_rating', true);}
        else{$enable_rating = 0;}

        if(!empty($this->input->post('time_interval'))){$time_interval = $this->input->post('time_interval', true);}
        else{$time_interval = 0;}

        if(!empty($this->input->post('size'))){$size = $this->input->post('size', true);}
        else{$size = '120px';}

        $data = array(
            'country' => $this->input->post('country', true),
            'name' => $this->input->post('name'),
            'title' => $this->input->post('title'),
            'category' => $this->input->post('category', true),
            'email' => $this->input->post('email', true),
            'phone' => $this->input->post('phone', true),
            'address' => $this->input->post('address'),
            'keywords' => $this->input->post('keywords'),
            'description' => $this->input->post('description'),
            'details' => $this->input->post('details'),
            'terms' => $this->input->post('terms', true),
            'privacy' => $this->input->post('privacy', true),
            'date_format' => $this->input->post('date_format', true),
            'time_format' => $this->input->post('time_format', true),
            'time_interval' => $time_interval,
            'size' => $size,
            'interval_type' => $this->input->post('interval_type', true),
            'interval_settings' => $this->input->post('interval_settings', true),
            'curr_locate' => $this->input->post('curr_locate', true),
            'num_format' => $this->input->post('num_format', true),
            'facebook' => $this->input->post('facebook', true),
            'twitter' => $this->input->post('twitter', true),
            'instagram' => $this->input->post('instagram', true),
            'whatsapp' => $this->input->post('whatsapp', true),
            'enable_gallery' => $enable_gallery,
            'enable_rating' => $enable_rating,
            'enable_staff' => $enable_staff,
            'about_title' => $this->input->post('about_title', true),
            'company_established' => $this->input->post('company_established', true),
            'about_vedio_url' => $this->input->post('about_vedio_url', true),
            'about_details' => $this->input->post('about_details', true)
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $id, 'business');

        // upload about image
        $data_img = $this->admin_model->do_upload('photo2');
        if($data_img){
            $data_img = array(
                'about_image' => $data_img['medium']
            );            
            $this->admin_model->edit_option($data_img, $id, 'business');
        }

        // upload logo
        $data_img = $this->admin_model->do_upload('photo1');
        if($data_img){
            $data_img = array(
                'logo' => $data_img['medium']
            );            
            $this->admin_model->edit_option($data_img, $id, 'business');
        }

        if($_FILES['photo']['name'] != ''){
            $up_load = $this->admin_model->upload_image('1600');
            $data_img_banner = array(
                'image' => $up_load['images'],
                'thumb' => $up_load['thumb']
            );
            $this->admin_model->edit_option($data_img_banner, $id, 'business');   
        }

        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/settings/company'));
    }


    public function general_settings(){

        check_status();

        $id = $this->input->post('id');

        if(!empty($this->input->post('enable_gallery'))){$enable_gallery = $this->input->post('enable_gallery', true);}
        else{$enable_gallery = 0;}

        if(!empty($this->input->post('enable_portfolio'))){$enable_portfolio = $this->input->post('enable_portfolio', true);}
        else{$enable_portfolio = 0;}

        if(!empty($this->input->post('enable_brand'))){$enable_brand = $this->input->post('enable_brand', true);}
        else{$enable_brand = 0;}

        if(!empty($this->input->post('enable_slider'))){$enable_slider = $this->input->post('enable_slider', true);}
        else{$enable_slider = 0;}

        if(!empty($this->input->post('enable_blog'))){$enable_blog = $this->input->post('enable_blog', true);}
        else{$enable_blog = 0;}

        if(!empty($this->input->post('enable_testimonial'))){$enable_testimonial = $this->input->post('enable_testimonial', true);}
        else{$enable_testimonial = 0;}

        if(!empty($this->input->post('enable_staff'))){$enable_staff = $this->input->post('enable_staff', true);}
        else{$enable_staff = 0;}

        if(!empty($this->input->post('enable_rating'))){$enable_rating = $this->input->post('enable_rating', true);}
        else{$enable_rating = 0;}

        if(!empty($this->input->post('enable_group'))){$enable_group = $this->input->post('enable_group', true);}
        else{$enable_group = 0;}

        if(!empty($this->input->post('time_interval'))){$time_interval = $this->input->post('time_interval', true);}
        else{$time_interval = 0;}

        if(!empty($this->input->post('enable_payment'))){$enable_payment = $this->input->post('enable_payment', true);}
        else{$enable_payment = 0;}

        if(!empty($this->input->post('enable_onsite'))){$enable_onsite = $this->input->post('enable_onsite', true);}
        else{$enable_onsite = 0;}

        if(!empty($this->input->post('enable_guest'))){$enable_guest = $this->input->post('enable_guest', true);}
        else{$enable_guest = 0;}

        if(!empty($this->input->post('default_timezone'))){$default_timezone = $this->input->post('default_timezone', true);}
        else{$default_timezone = 0;}

        if(!empty($this->input->post('enable_event'))){$enable_event = $this->input->post('enable_event', true);}
        else{$enable_event = 0;}

        if(!empty($this->input->post('enable_product'))){$enable_product = $this->input->post('enable_product', true);}
        else{$enable_product = 0;}

        if(!empty($this->input->post('enable_timepass'))){$enable_timepass = $this->input->post('enable_timepass', true);}
        else{$enable_timepass = 0;}

        $data = array(
            'lang' => $this->input->post('language', true),
            'country' => $this->input->post('country', true),
            'date_format' => $this->input->post('date_format', true),
            'time_format' => $this->input->post('time_format', true),
            'time_zone' => $this->input->post('time_zone', true),
            'enable_onsite' => $enable_onsite,
            'enable_payment' => $enable_payment,
            'time_interval' => $time_interval,
            'interval_type' => $this->input->post('interval_type', true),
            'interval_settings' => $this->input->post('interval_settings', true),
            'cancelation_time' => $this->input->post('cancelation_time', true),
            'curr_locate' => $this->input->post('curr_locate', true),
            'num_format' => $this->input->post('num_format', true),
            'total_person' => $this->input->post('total_person', true),
            'tax_type' => $this->input->post('tax_type', true),
            'tax_amount' => $this->input->post('tax_amount', true),
            'card_fee' => $this->input->post('card_fee', true),
            'enable_gallery' => $enable_gallery,
            'enable_portfolio' => $enable_portfolio,
            'enable_brand' => $enable_brand,
            'enable_slider' => $enable_slider,
            'enable_blog' => $enable_blog,
            'enable_testimonial' => $enable_testimonial,
            'enable_rating' => $enable_rating,
            'enable_group' => $enable_group,
            'enable_guest' => $enable_guest,
            'default_timezone' => $default_timezone,
            'enable_event' => $enable_event,
            'enable_product' => $enable_product,
            'enable_timepass' => $enable_timepass,
            'enable_staff' => $enable_staff
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $id, 'business');
        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/settings/general'));
    }


    public function update_theme(){

        check_status();

        $data = array(
            'color' => str_replace('#', '', $this->input->post('color')),
            'font' => $this->input->post('font'),
            'template_style' => $this->input->post('template_style', true),
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $this->business->id, 'business');

        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/settings/themes'));
    }


    public function update_time_format(){

        check_status();

        $data = array(
            'time_format' => $this->input->post('time_format', true)
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $this->business->id, 'business');

        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/settings/working_hours'));
    }


    public function update_profile(){

        check_status();

        $data = array(
            'name' => $this->input->post('name', true),
            'email' => $this->input->post('email', true),
            'phone' => $this->input->post('phone', true)
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, user()->id, 'users');

        if($_FILES['photo']['name'] != ''){
            $up_load = $this->admin_model->upload_image('800');
            $data_img = array(
                'image' => $up_load['images'],
                'thumb' => $up_load['thumb']
            );
            $this->admin_model->edit_option($data_img, user()->id, 'users');   
        }

        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/settings/profile'));
    }

    public function update_sms(){

        $data = array(
            'twillo_account_sid' => $this->input->post('twillo_account_sid', true),
            'twillo_auth_token' => $this->input->post('twillo_auth_token', true),
            'twillo_number' => $this->input->post('twillo_number', true),
            'enable_sms_notify' => $this->input->post('enable_sms_notify', true),
            'enable_sms_alert' => $this->input->post('enable_sms_alert', true)
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, user()->id, 'users');
        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/settings/sms'));
    }


    public function update_whatsapp(){
        
        if(!empty($this->input->post('enable_whatsapp_msg'))){$enable_whatsapp_msg = $this->input->post('enable_whatsapp_msg', true);}
        else{$enable_whatsapp_msg = 0;}

        $data = array(
            'whatsapp_type' => $this->input->post('whatsapp_type', true),
            'ultramsg_instance_id' => $this->input->post('ultramsg_instance_id'),
            'ultramsg_token' => $this->input->post('ultramsg_token'),
            'wazfy_instance_id' => $this->input->post('wazfy_instance_id', true),
            'wazfy_token' => $this->input->post('wazfy_token', true),
            'wappblaster_key' => $this->input->post('wappblaster_key', true),
            'enable_whatsapp_msg' => $enable_whatsapp_msg
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $this->business->id, 'business');
        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/settings/whatsapp'));
    }

    public function update_meeting(){
        
        

        $data = array(
            'default_meeting' => $this->input->post('default_meeting', true),
            'zoom_account_id' => $this->input->post('zoom_account_id'),
            'zoom_client_id' => $this->input->post('zoom_client_id'),
            'zoom_client_secret' => $this->input->post('zoom_client_secret', true),
            'meet_client_id' => $this->input->post('meet_client_id', true),
            'meet_client_secret' => $this->input->post('meet_client_secret', true),
            'meet_redirect_url' => $this->input->post('meet_redirect_url', true)
        );
  
        $data = $this->security->xss_clean($data);
        $this->admin_model->edit_option($data, $this->business->id, 'business');
        $this->session->set_flashdata('msg', trans('updated-successfully')); 
        redirect(base_url('admin/settings/meeting'));
    }


    //set default language
    public function set_language()
    {
        check_status();

        if ($_POST) {

            if(!empty($this->input->post('enable_multilingual'))){$enable_multilingual = $this->input->post('enable_multilingual', true);}else{$enable_multilingual = 0;}

            $data = array(
                'enable_multilingual' => $enable_multilingual,
                'lang' => $this->input->post('language', true)
            );
            $data = $this->security->xss_clean($data);
            $this->admin_model->edit_option($data, 1, 'settings');
            $this->session->set_flashdata('msg', trans('updated-successfully')); 
            redirect(base_url('admin/language'));
        }
    }

    
    //update settings
    public function update(){

        check_status();

        if ($_POST) {

            $this->pwa_logo_upload();

            if(!empty($this->input->post('enable_multilingual'))){$enable_multilingual = $this->input->post('enable_multilingual', true);}
            else{$enable_multilingual = 0;}

            if(!empty($this->input->post('enable_registration'))){$enable_registration = $this->input->post('enable_registration', true);}
            else{$enable_registration = 0;}

            if(!empty($this->input->post('enable_email_verify'))){$enable_email_verify = $this->input->post('enable_email_verify', true);}
            else{$enable_email_verify = 0;}

            if(!empty($this->input->post('enable_sms'))){$enable_sms = $this->input->post('enable_sms', true);}
            else{$enable_sms = 0;}

            if(!empty($this->input->post('enable_captcha'))){$enable_captcha = $this->input->post('enable_captcha', true);}
            else{$enable_captcha = 0;}

            if(!empty($this->input->post('enable_payment'))){$enable_payment = $this->input->post('enable_payment', true);}
            else{$enable_payment = 0;}

            if(!empty($this->input->post('enable_blog'))){$enable_blog = $this->input->post('enable_blog', true);}
            else{$enable_blog = 0;}

            if(!empty($this->input->post('enable_faq'))){$enable_faq = $this->input->post('enable_faq', true);}
            else{$enable_faq = 0;}

            if(!empty($this->input->post('enable_users'))){$enable_users = $this->input->post('enable_users', true);}
            else{$enable_users = 0;}

            if(!empty($this->input->post('enable_workflow'))){$enable_workflow = $this->input->post('enable_workflow', true);}
            else{$enable_workflow = 0;}

            if(!empty($this->input->post('enable_feature'))){$enable_feature = $this->input->post('enable_feature', true);}
            else{$enable_feature = 0;}

            if(!empty($this->input->post('enable_frontend'))){$enable_frontend = $this->input->post('enable_frontend', true);}
            else{$enable_frontend = 0;}

            if(!empty($this->input->post('enable_lifetime'))){$enable_lifetime = $this->input->post('enable_lifetime', true);}
            else{$enable_lifetime = 0;}

            if(!empty($this->input->post('enable_coupon'))){$enable_coupon = $this->input->post('enable_coupon', true);}
            else{$enable_coupon = 0;}

            if(!empty($this->input->post('enable_animation'))){$enable_animation = $this->input->post('enable_animation', true);}
            else{$enable_animation = 0;}

            if(!empty($this->input->post('enable_embed_badge'))){$enable_embed_badge = $this->input->post('enable_embed_badge', true);}
            else{$enable_embed_badge = 0;}

            if(!empty($this->input->post('enable_default_tzone'))){$enable_default_tzone = $this->input->post('enable_default_tzone', true);}
            else{$enable_default_tzone = 0;}

            if(!empty($this->input->post('enable_openai'))){$enable_openai = $this->input->post('enable_openai', true);}
            else{$enable_openai = 0;}

            if(!empty($this->input->post('enable_cdomain'))){$enable_cdomain = $this->input->post('enable_cdomain', true);}
            else{$enable_cdomain = 0;}

            if(!empty($this->input->post('global_twilio'))){$global_twilio = $this->input->post('global_twilio', true);}
            else{$global_twilio = 0;}

            if(!empty($this->input->post('global_wapp_msg'))){$global_wapp_msg = $this->input->post('global_wapp_msg', true);}
            else{$global_wapp_msg = 0;}

            if(!empty($this->input->post('enable_pwa', true))){$enable_pwa = $this->input->post('enable_pwa', true);}
            else{$enable_pwa = 0;}

            if(!empty($this->input->post('home_layout', true))){$home_layout = $this->input->post('home_layout', true);}
            else{$home_layout = 3;}

            $custom_css = $this->security->xss_clean($this->input->post('custom_css', true));
     
            $data = array(
                'site_name' => $this->input->post('site_name')[0],
                'site_title' => $this->input->post('site_title')[0],
                'keywords' => $this->input->post('keywords')[0],
                'description' => $this->input->post('description')[0],
                'footer_about' => $this->input->post('footer_about')[0],
                'copyright' => $this->input->post('copyright')[0],
                'admin_email' => $this->input->post('admin_email', true),
                'time_zone' => $this->input->post('time_zone', true),
                'reminder_before' => $this->input->post('reminder_before', true),
                'pagination_limit' => 0,
                'enable_pwa' => $enable_pwa,
                'custom_css' => json_encode($custom_css),
                'country' => $this->input->post('country', true),
                'trial_days' => $this->input->post('trial_days', true),
                'facebook' => $this->input->post('facebook', true),
                'twitter' => $this->input->post('twitter', true),
                'instagram' => $this->input->post('instagram', true),
                'linkedin' => $this->input->post('linkedin', true),
                'chart_style' => $this->input->post('chart_style', true),
                'curr_locate' => $this->input->post('curr_locate', true),
                'num_format' => $this->input->post('num_format', true),
                'openai_key' => $this->input->post('openai_key', true),
                'openai_model' => $this->input->post('openai_model', true),
                'enable_openai' => $enable_openai,
                'enable_cdomain' => $enable_cdomain,
                'enable_multilingual' => $enable_multilingual,
                'enable_registration' => $enable_registration,
                'enable_captcha' => $enable_captcha,
                'enable_payment' => $enable_payment,
                'enable_blog' => $enable_blog,
                'enable_faq' => $enable_faq,
                'enable_users' => $enable_users,
                'enable_workflow' => $enable_workflow,
                'enable_feature' => $enable_feature,
                'enable_frontend' => $enable_frontend,
                'enable_lifetime' => $enable_lifetime,
                'enable_coupon' => $enable_coupon,
                'enable_animation' => $enable_animation,
                'enable_embed_badge' => $enable_embed_badge,
                'enable_default_tzone' => $enable_default_tzone,
                'enable_email_verify' => $enable_email_verify,
                'enable_sms' => $enable_sms,
                'google_analytics' => base64_encode($this->input->post('google_analytics')),
                'site_color' => str_replace('#', '', $this->input->post('site_color')),
                'site_mode' => $this->input->post('site_mode', true),
                'layout' => $this->input->post('layout', true),
                'home_layout' => $home_layout,
                'site_font' => 'Alata',
                'captcha_site_key' => $this->input->post('captcha_site_key', true),
                'captcha_secret_key' => $this->input->post('captcha_secret_key', true),
                'google_client_id' => trim($this->input->post('google_client_id', true)),
                'google_client_secret' => trim($this->input->post('google_client_secret', true)),
                'mail_protocol' => $this->input->post('mail_protocol', true),
                'sender_mail' => $this->input->post('sender_mail', true),
                'mail_title' => $this->input->post('mail_title', true),
                'mail_host' => $this->input->post('mail_host', true),
                'mail_port' => $this->input->post('mail_port', true),
                'mail_username' => $this->input->post('mail_username', true),
                'mail_password' => base64_encode($this->input->post('mail_password')),
                'mail_encryption' => $this->input->post('mail_encryption'),
                'twillo_account_sid' => $this->input->post('twillo_account_sid', true),
                'twillo_auth_token' => $this->input->post('twillo_auth_token', true),
                'twillo_number' => $this->input->post('twillo_number', true),
                'tax_name' => $this->input->post('tax_name', true),
                'tax_value' => $this->input->post('tax_value', true),
                'card_fee' => $this->input->post('card_fee', true),
                'global_twilio' => $global_twilio,
                'global_wapp_msg' => $global_wapp_msg,
                'ultramsg_instance_id' => $this->input->post('ultramsg_instance_id', true),
                'ultramsg_token' => $this->input->post('ultramsg_token', true),
                'whatsapp_type' => $this->input->post('whatsapp_type', true),
                'wazfy_instance_id' => $this->input->post('wazfy_instance_id', true),
                'wazfy_token' => $this->input->post('wazfy_token', true),
                'wappblaster_key' => $this->input->post('wappblaster_key', true)
            );
            
            // upload favicon image
            $data_img = $this->admin_model->do_upload('photo1');
            if($data_img){
                $data_img_1 = array(
                    'favicon' => $data_img['thumb']
                );
                $this->admin_model->edit_option($data_img_1, 1, 'settings'); 
             }

            // upload logo
            $data_img2 = $this->admin_model->do_upload('photo2');
            if($data_img2){
                $data_img_2 = array(
                    'logo' => $data_img2['medium']
                );            
                $this->admin_model->edit_option($data_img_2, 1, 'settings');
            }

            // upload home hero image
            $data_img4 = $this->admin_model->do_upload('photo4');

            if($data_img4){
                $data_img_4 = array(
                    'logo_light' => $data_img4['medium']
                );            
                $this->admin_model->edit_option($data_img_4, 1, 'settings');
            }


            // upload home hero image
            $data_img3 = $this->admin_model->do_upload('photo3');
            if($data_img3){
                $data_img_3 = array(
                    'hero_img' => $data_img3['medium']
                );            
                $this->admin_model->edit_option($data_img_3, 1, 'settings');
            }

            $user_data = array(
                'email' => $this->input->post('admin_email', true)        
            );
            
            $user_data = $this->security->xss_clean($user_data);
            $this->admin_model->edit_option($user_data, user()->id, 'users');
            $data = $this->security->xss_clean($data);

            $lang_id = $this->input->post('lang_id');
            $site_name = $this->input->post('site_name');
            $site_title = $this->input->post('site_title');
            $keywords = $this->input->post('keywords');
            $description = $this->input->post('description');
            $footer_about = $this->input->post('footer_about');
            $copyright = $this->input->post('copyright');

            for($l = 0; $l < sizeof($lang_id); $l++){
                $sdata = array(
                    'site_name' => $site_name[$l],
                    'site_title' => $site_title[$l],
                    'keywords' => $keywords[$l],
                    'description' => $description[$l],
                    'footer_about' => $footer_about[$l],
                    'copyright' => $copyright[$l]
                );
                $this->admin_model->edit_option($sdata, $lang_id[$l], 'settings_extra');
            }  

            $batch_data = array(
                array(
                  'key' => 'enable_google',
                  'value' => !empty($this->input->post('enable_google'))?$this->input->post('enable_google'):'0'
                ),
                array(
                  'key' => 'enable_facebook',
                  'value' => !empty($this->input->post('enable_facebook'))?$this->input->post('enable_facebook'):'0'
                ),
                array(
                  'key' => 'google_client_id',
                  'value' => $this->input->post('google_client_id_log')
                ),
                array(
                  'key' => 'google_secret_key',
                  'value' => $this->input->post('google_secret_key')
                ),
                array(
                  'key' => 'google_redirect',
                  'value' => base_url('login')
                ),
                array(
                  'key' => 'facebook_app_id',
                  'value' => $this->input->post('facebook_app_id')
                ),
                array(
                  'key' => 'facebook_app_secret',
                  'value' => $this->input->post('facebook_app_secret')
                ),
                array(
                  'key' => 'facebook_graph_version',
                  'value' => $this->input->post('facebook_graph_version')
                )
            );
            $this->db->update_batch('system_settings', $batch_data, 'key');


            $this->admin_model->edit_option($data, 1, 'settings');
            $this->session->set_flashdata('msg', trans('updated-successfully')); 
            redirect($_SERVER['HTTP_REFERER']);
        }
    }


    public function pwa_logo_upload() {
        if (!empty($_FILES['pwa_logo']['name'])) {
            $config['upload_path']          = './uploads/files'; //file save path
            $config['allowed_types']        = 'jpg|png|jpeg';
            $config['max_size']             = 512;
            $config['encrypt_name']         = TRUE;

            $this->load->library('upload', $config);
            if ( ! $this->upload->do_upload('pwa_logo')){
                // Upload failed, display error
                $error = array('error' => $this->upload->display_errors());
                $this->session->set_flashdata('error', $error);
            } else {
                // Upload success, check image dimensions
                $upload_data = $this->upload->data();
                $file_path = $upload_data['full_path'];
                $file_name = $upload_data['file_name'];
                list($width, $height) = getimagesize($file_path);
                //echo $width.' = '.$height; exit();
                // Check dimensions here
                if ($width != 512 && $height != 512) {
                    unlink($file_path);
                    $error = trans('pwa-logo-size-alert');
                    $this->session->set_flashdata('error', $error); 
                } else {
                    $cdata=array(
                        'pwa_logo' => 'uploads/files/'.$file_name
                    );
                    $cdata = $this->security->xss_clean($cdata);
                    $this->admin_model->edit_option($cdata, 1, 'settings');
                }
            }
        }
    }


    public function license()
    {
        if (!is_admin()) {
            redirect(base_url());
        }

        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'License';
        $data['main_content'] = $this->load->view('admin/license', $data, TRUE);
        $this->load->view('admin/index', $data);
    }

    public function change_password()
    {
        if (!is_admin() && !is_user()) {
            redirect(base_url());
        }

        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'Change Password';
        $data['main_content'] = $this->load->view('admin/user/change_password', $data, TRUE);
        $this->load->view('admin/index', $data);
    }


    //change password
    public function change()
    {   
        check_status();

        if($_POST){
            
            $id = user()->id;
            $user = $this->admin_model->get_by_id($id, 'users');

            if(password_verify($this->input->post('old_pass', true), $user->password)){
                if ($this->input->post('new_pass', true) == $this->input->post('confirm_pass', true)) {
                    $data=array(
                        'password' => hash_password($this->input->post('new_pass', true))
                    );
                    $data = $this->security->xss_clean($data);
                    $this->admin_model->edit_option($data, $id, 'users');
                    echo json_encode(array('st'=>1));
                } else {
                    echo json_encode(array('st'=>2));
                }
            } else {
                echo json_encode(array('st'=>0));
            }
        }
    }



    //user settings
    public function working_hours()
    {
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'Working Hours';
        $data['my_days'] = $this->admin_model->get_user_days(0);
        $data['main_content'] = $this->load->view('admin/user/working_hours',$data,TRUE);
        $this->load->view('admin/index',$data);
    }


    public function themes()
    {
        $data = array();
        $data['page'] = 'Settings';
        $data['page_title'] = 'Themes';
        $data['fonts'] = $this->admin_model->select_by_user_or_admin('fonts');
        $data['main_content'] = $this->load->view('admin/user/themes',$data,TRUE);
        $this->load->view('admin/index',$data);
    }

    
    public function set()
    {   
        check_status();

        $user_id = user()->id;
        $this->admin_model->delete_assaign_days($user_id, 'working_days');
        $this->admin_model->delete_assaign_time($user_id, 'working_time');

        if($_POST)
        {   
            for ($i=0; $i < 7; $i++) { 
                if(empty($this->input->post("day_".$i))){
                    $day = 0;
                }else{
                    $day = $this->input->post("day_".$i);
                }

                if ($day == 0) {
                    $start = '';
                    $end = '';
                }else{
                    $start = $this->input->post("start_hour_".$i);
                    $end = $this->input->post("end_hour_".$i);
                    $start = date("H:i", strtotime($start));
                    $end = date("H:i", strtotime($end));
                }


                $data = array(
                    'user_id' => $user_id,
                    'business_id' => $this->business->uid,
                    'day' => $day,
                    'start' => $start,
                    'end' => $end,
                );
                $data = $this->security->xss_clean($data);
                $this->admin_model->insert($data, 'working_days');

                if ($day != 0) {
                    
                    if ($day == 0) {
                        $start_time = '';
                        $end_time = '';
                    }else{
                        $start_time = $this->input->post("start_time_".$i);
                        $end_time = $this->input->post("end_time_".$i);
                    }

                    $phpversion = phpversion();
                    if ($phpversion <= 8.0) {
                        for ($a=0; $a < count($start_time); $a++) {
                            $time_data = array(
                                'user_id' => $user_id,
                                'business_id' => $this->business->uid,
                                'day_id' => $day,
                                'time' => date("H:i", strtotime($start_time[$a])).'-'.date("H:i", strtotime($end_time[$a])),
                                'start' => date("H:i", strtotime($start_time[$a])),
                                'end' => date("H:i", strtotime($end_time[$a]))
                            );
                            $time_data = $this->security->xss_clean($time_data);
                            $this->admin_model->insert($time_data, 'working_time');
                        }
                    }else{

                        if (is_countable($start_time)) {
                            $limit = count($start_time);
                        }else{
                            $limit =0;
                        }

                        for ($a=0; $a < $limit; $a++) {
                            $time_data = array(
                                'user_id' => $user_id,
                                'business_id' => $this->business->uid,
                                'day_id' => $day,
                                'time' => date("H:i", strtotime($start_time[$a])).'-'.date("H:i", strtotime($end_time[$a])),
                                'start' => date("H:i", strtotime($start_time[$a])),
                                'end' => date("H:i", strtotime($end_time[$a]))
                            );
                            $time_data = $this->security->xss_clean($time_data);
                            $this->admin_model->insert($time_data, 'working_time');
                        }
                    }
                    
                }
            }


            $this->session->set_flashdata('msg', trans('updated-successfully')); 
            redirect(base_url('admin/settings/working_hours'));
        }      
        
    }


    public function set_time()
    {   
        check_status();
        
        $this->admin_model->delete_assaign_time($user_id, 'working_time');
        $data = array(
            'user_id' => $user_id,
            'business_id' => $this->business->uid,
            'day_id' => $day,
            'start' => $day,
            'end' => $day
        );
        $data = $this->security->xss_clean($data);
        $this->admin_model->insert($data, 'working_time');
    }

    public function delete_time($id)
    {
        $this->admin_model->delete($id,'working_time'); 
        echo json_encode(array('st' => 1));
    }

    


}